<h1 align="center">
  <img src="./README_assets/img/mascot.jpg" alt="Karing" width="256" />
  <br>
  Karing - Enkelt og kraftig proxyverktøy
  <br>
</h1>

<h3 align="center">
En <a href="https://github.com/SagerNet/sing-box">singbox</a>-GUI basert på <a href="https://github.com/flutter/flutter">flutter</a>.
</h3>

[English](./README.md) | [简体中文](./README_cn.md) | [繁體中文](./README_tw.md) | [日本語](./README_ja.md) | [한국어](./README_ko.md) | [Español](./README_es.md) | [Français](./README_fr.md) | [Deutsch](./README_de.md) | [Italiano](./README_it.md) | [Tiếng Việt](./README_vi.md) | [Türkçe](./README_tr.md) | [Русский](./README_ru.md) | [فارسی](./README_fa.md) | [العربية](./README_ar.md) | [Português](./README_pt.md) | [Українська](./README_uk.md) | [Polski](./README_pl.md) | [اردو](./README_ur.md) | [Svenska](./README_sv.md) | Norsk | [Nederlands](./README_nl.md) | [हिन्दी](./README_hi.md) | [Ελληνικά](./README_el.md) | [Dansk](./README_da.md) | [বাংলা](./README_bn.md)

### Merk: Karing har ikke åpnet noen kanal relatert til Karing på noen videoplattform.

## Funksjoner
- Kompatibel med abonnementer fra Clash, V2ray/V2fly, Sing-box, Shadowsocks, Sub, Github.
  - Full støtte for `clash`-konfigurasjon, delvis støtte for `clash.meta`-konfigurasjon.

- Et sett med rutingregler som brukes på flere abonnementskilder, velger automatisk effektive noder.
- Støtter tilpassede rutingregelgrupper og nodegrupper.
  - Tilpasser standard rutingregelgrupper for nybegynnere - klar til bruk rett ut av esken.
  - Innebygd geo-IP, geo-site, ACL og [andre regelsett](https://github.com/KaringX/karing-ruleset/).

- Sikkerhetskopiering og synkronisering, synkroniser flere enheter med én enkelt konfigurasjon.
  - Støtter iCloud-synkronisering [IOS/MacOS].
  - Støtter synkronisering innenfor det lokale nettverket.
  - Støtter WebDAV.
  - Støtter import/eksport av ZIP-filer.

- Innebygd støtte for den [modifiserte sing-box-kjernen](https://github.com/KaringX/sing-box).
- Introduserer en nybegynnermodus for enklere konfigurasjon.
- Planlegger å støtte flere plattformer.

## Kampanjer
<details>
<summary>Vis alle kampanjer

### Anbefalt VPN

[Doggygo VPN —— Akselerasjon for eksperter](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)

- Høyytelses utenlandsk leverandør (Airport), internasjonalt team, ingen risiko for stenging.
- Registrering via eksklusiv lenke gir 3 dager og 1G daglig trafikk [Gratis prøveperiode](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053).
- Rabatterte pakker fra bare 15,8 yuan per måned, 160G trafikk, 20 % rabatt ved årsbetaling.
- Først i verden med støtte for `Hysteria2`-protokollen, klynge-lastbalanseringsdesign, høyhastighets dedikert linje, ekstremt lav ventetid, ignorerer nattlige topper, 4K umiddelbart.
- Låser opp strømmemedier og ChatGPT.

[👉 Flere tilbud oppdateres daglig](https://1.x31415926.top/)

</summary>

### 🤝 Samarbeidsmelding for VPN-leverandører
- 👉 [Kontaktinformasjon og samarbeidsformer](https://karing.app/blog/isp/cooperation#for-vpn-providers-from-other-regions) 👈
</details>

## Systemkrav
- Windows >= 10 (bare 64-bit)
- Android >= 8 (arm64-v8a, armeabi-v7a)
- Linux (bare 64-bit)
- IOS >= 15
- MacOS >= 12 (Intel, Apple Silicon)
- TvOS >= 17

## Installasjon
- **IOS/TvOS AppStore**: (Søkeord: karing vpn)
  - https://apps.apple.com/us/app/karing/id6472431552
- **IOS/TvOS TestFlight**:
  - https://testflight.apple.com/join/RLU59OsJ
- **Android**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
  - APKPure https://apkpure.com/p/com.nebula.karing
  - Amazon AppStore https://www.amazon.com/gp/product/B0DJSQDDM8
- **Windows/Macos/Linux**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest

### FAQ (Vanlige spørsmål)

> [FAQ|no](https://karing.app/en/faq/)

## Gjenværende oppgaver (Todos)
- Plattformer som vil bli støttet:
  - linux | [linglong](https://linglong.dev/)
- Globalisering (flerspråklig)
  - Hvis du er villig til å jobbe med oss for å støtte globaliseringen av Karing, vennligst kontakt oss via [Telegram](https://t.me/ovowe).

## Skjermbilder

<div align="center">
  <img src="./README_assets/demo/home.png" alt="demo1" width="50%" />
  </br></br>
  <img src="./README_assets/demo/select_server.png" alt="demo2" width="50%" />
    </br></br>
  <img src="./README_assets/demo/connections.png" alt="demo3" width="50%" />
  </br></br>
  <img src="./README_assets/demo/setting.png" alt="demo4" width="50%" />
  </br></br>
  <img src="./README_assets/demo/routing_group.png" alt="demo5" width="50%" />
  </br></br>
  <img src="./README_assets/demo/add_profile_link.png" alt="demo6" width="50%" />
</div>

## Bidrag
[Velkommen til å rapportere feil!](https://github.com/KaringX/karing/issues)

## Doner
![donate](./README_assets/img/donate-usdt.jpg)

## Prosjekter
### Takk til: Karing ble basert på eller inspirert av disse prosjektene:

- [flutter](https://flutter.dev/): gjør det enkelt og raskt å bygge vakre apper for mobil og mer.
- [singbox](https://sing-box.sagernet.org/): Den universelle proxy-plattformen.
- [Meta-Docs](https://wiki.metacubex.one/config/): Clash.Meta-dokumentasjon

### Karing-teamet:
- [Karing](https://karing.app): https://karing.app
- [Clash Mi](https://clashmi.app/): https://clashmi.app/
- [sing-poet](https://github.com/KaringX/sing-poet)

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=KaringX/karing&type=Date)](https://star-history.com/#KaringX/karing&Date)
