<h1 align="center">
  <img src="./README_assets/img/mascot.jpg" alt="Karing" width="256" />
  <br>
  Karing - Enkelt og kraftfuldt proxy-værktøj
  <br>
</h1>

<h3 align="center">
En <a href="https://github.com/SagerNet/sing-box">singbox</a>-GUI baseret på <a href="https://github.com/flutter/flutter">flutter</a>.
</h3>

[English](./README.md) | [简体中文](./README_cn.md) | [繁體中文](./README_tw.md) | [日本語](./README_ja.md) | [한국어](./README_ko.md) | [Español](./README_es.md) | [Français](./README_fr.md) | [Deutsch](./README_de.md) | [Italiano](./README_it.md) | [Tiếng Việt](./README_vi.md) | [Türkçe](./README_tr.md) | [Русский](./README_ru.md) | [فارسی](./README_fa.md) | [العربية](./README_ar.md) | [Português](./README_pt.md) | [Українська](./README_uk.md) | [Polski](./README_pl.md) | [اردو](./README_ur.md) | [Svenska](./README_sv.md) | [Norsk](./README_no.md) | [Nederlands](./README_nl.md) | [हिन्दी](./README_hi.md) | [Ελληνικά](./README_el.md) | Dansk | [বাংলা](./README_bn.md)

### Bemærk: Karing har ikke åbnet nogen kanal relateret til Karing på nogen videoplatform.

## Funktioner
- Kompatibel med abonnementer fra Clash, V2ray/V2fly, Sing-box, Shadowsocks, Sub, Github.
  - Fuld understøttelse af `clash`-konfiguration, delvis understøttelse af `clash.meta`-konfiguration.

- Et sæt ruterregler anvendt på flere abonnementskilder vælger automatisk effektive noder.
- Understøtter brugerdefinerede ruterregelgrupper og nodegrupper.
  - Tilpasser standard ruterregelgrupper til begyndere - klar til brug med det samme.
  - Indbygget geo-IP, geo-site, ACL og [andre regelsæt](https://github.com/KaringX/karing-ruleset/).

- Sikkerhedskopiering og synkronisering, synkronisering af flere enheder med en enkelt konfiguration.
  - Understøtter iCloud-synkronisering [IOS/MacOS].
  - Understøtter synkronisering inden for det lokale netværk.
  - Understøtter WebDAV.
  - Understøtter import/eksport af ZIP-filer.

- Indbygget understøttelse af den [modificerede sing-box-kerne](https://github.com/KaringX/sing-box).
- Introducerer en begyndertilstand for enklere konfiguration.
- Planer om at understøtte flere platforme.

## Kampagner
<details>
<summary>Se alle kampagner

### Anbefalet VPN

[Doggygo VPN —— Acceleration for eksperter](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)

- Højtydende udenlandsk udbyder (Airport), internationalt team, ingen risiko for lukning.
- Registrering via eksklusivt link giver 3 dage og 1G daglig trafik [Gratis prøveperiode](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053).
- Rabatpakker fra kun 15,8 yuan om måneden, 160G trafik, 20% rabat ved årlig betaling.
- Først i verden med understøttelse af `Hysteria2`-protokollen, klynge-belastningsbalanceringsdesign, højhastigheds dedikeret linje, ekstremt lav ventetid, ignorerer natlige toppe, 4K med det samme.
- Låser op for streamingmedier og ChatGPT.

[👉 Flere tilbud opdateres dagligt](https://1.x31415926.top/)

</summary>

### 🤝 Samarbejdsmeddelelse for VPN-udbydere
- 👉 [Kontaktoplysninger og samarbejdsformer](https://karing.app/blog/isp/cooperation#for-vpn-providers-from-other-regions) 👈
</details>

## Systemkrav
- Windows >= 10 (kun 64-bit)
- Android >= 8 (arm64-v8a, armeabi-v7a)
- Linux (kun 64-bit)
- IOS >= 15
- MacOS >= 12 (Intel, Apple Silicon)
- TvOS >= 17

## Installation
- **IOS/TvOS AppStore**: (Søgeord: karing vpn)
  - https://apps.apple.com/us/app/karing/id6472431552
- **IOS/TvOS TestFlight**:
  - https://testflight.apple.com/join/RLU59OsJ
- **Android**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
  - APKPure https://apkpure.com/p/com.nebula.karing
  - Amazon AppStore https://www.amazon.com/gp/product/B0DJSQDDM8
- **Windows/Macos/Linux**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest

### FAQ (Ofte stillede spørgsmål)

> [FAQ|da](https://karing.app/en/faq/)

## Opgaver (Todos)
- Platforme, der vil blive understøttet:
  - linux | [linglong](https://linglong.dev/)
- Globalisering (flersprogethed)
  - Hvis du er villig til at arbejde sammen med os om at støtte globaliseringen af Karing, bedes du kontakte os via [Telegram](https://t.me/ovowe).

## Skærmbilleder

<div align="center">
  <img src="./README_assets/demo/home.png" alt="demo1" width="50%" />
  </br></br>
  <img src="./README_assets/demo/select_server.png" alt="demo2" width="50%" />
    </br></br>
  <img src="./README_assets/demo/connections.png" alt="demo3" width="50%" />
  </br></br>
  <img src="./README_assets/demo/setting.png" alt="demo4" width="50%" />
  </br></br>
  <img src="./README_assets/demo/routing_group.png" alt="demo5" width="50%" />
  </br></br>
  <img src="./README_assets/demo/add_profile_link.png" alt="demo6" width="50%" />
</div>

## Bidrag
[Velkommen til at rapportere problemer!](https://github.com/KaringX/karing/issues)

## Donér
![donate](./README_assets/img/donate-usdt.jpg)

## Projekter
### Anerkendelse: Karing er baseret på eller inspireret af disse projekter:

- [flutter](https://flutter.dev/): gør det nemt og hurtigt at bygge smukke apps til mobil og mere.
- [singbox](https://sing-box.sagernet.org/): Den universelle proxy-platform.
- [Meta-Docs](https://wiki.metacubex.one/config/): Clash.Meta-dokumentation

### Karing-teamet:
- [Karing](https://karing.app): https://karing.app
- [Clash Mi](https://clashmi.app/): https://clashmi.app/
- [sing-poet](https://github.com/KaringX/sing-poet)

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=KaringX/karing&type=Date)](https://star-history.com/#KaringX/karing&Date)
